/*****************************************************************************
 * ugBASIC - an isomorphic BASIC language compiler for retrocomputers        *
 *****************************************************************************
 * Copyright 2021-2022 Marco Spedaletti (asimov@mclink.it)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *----------------------------------------------------------------------------
 * Concesso in licenza secondo i termini della Licenza Apache, versione 2.0
 * (la "Licenza"); è proibito usare questo file se non in conformità alla
 * Licenza. Una copia della Licenza è disponibile all'indirizzo:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Se non richiesto dalla legislazione vigente o concordato per iscritto,
 * il software distribuito nei termini della Licenza è distribuito
 * "COSÌ COM'È", SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO, esplicite o
 * implicite. Consultare la Licenza per il testo specifico che regola le
 * autorizzazioni e le limitazioni previste dalla medesima.
 ****************************************************************************/

/****************************************************************************
 * INCLUDE SECTION 
 ****************************************************************************/

#include "../../ugbc.h"

/****************************************************************************
 * CODE SECTION 
 ****************************************************************************/

/**
 * @brief Emit ASM code for <b>= RANDOM WIDTH</b>
 * 
 * This function outputs a code suitable for calculating a random width.
 * 
 * @param _environment Current calling environment
 * @return Variable* The random value calculated
 */
/* <usermanual>
@keyword RANDOM WIDTH

@english
Calculate a random width.

@italian
Calcola un valore di larghezza casuale.

@syntax = RANDOM WIDTH

@example POINT AT (RANDOM WIDTH, RANDOM HEIGHT)

@target c64
</usermanual> */
Variable * random_width( Environment * _environment ) {
 
    Variable * result1 = random_value( _environment, VT_POSITION );
    Variable * result2 = random_value( _environment, VT_POSITION );

    cpu6502_limit_16bit( _environment, result1->realName, 255 );
    cpu6502_limit_16bit( _environment, result2->realName, 63 );

    return variable_add( _environment, result1->name, result2->name );

}